/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.sas;

import com.ibm.hwmca.fw.rcs.sas.SasUtil;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ClientLocation
implements Serializable {
    private static final String TRACE_MASKT = "XSASCLOT";
    private static final String TRACE_MASKF = "XSASCLOD";
    private static final String TRACE_MASKD = "XSASCLOF";
    public static final String ISO2CH = "ISO2CH";
    public static final String ISO3CH = "ISO3CH";
    public static final String RETAIN = "RETAIN";
    private static final String CLIENT_LOCATION = "client-location";
    private static final String COUNTRY_CODE = "country-code";
    private static final String COUNTRY_CODE_TYPE = "country-code-type";
    private static final String STATE_OR_PROVINCE = "state-or-province";
    private static final String CITY_OR_LOCALITY = "city-or-locality";
    private static final String POSTAL_CODE = "postal-code";
    private static final String STREET_ADDRESS = "street-address";
    private static final String STREET_ADDRESS2 = "street-address2";
    private static final String TIMEZONE = "timezone";
    private static final String LOCALE = "locale";
    private static final String LAST_UPDATE_TIMESTAMP = "last-update_TIMESTAMP";
    public String countryCode;
    public String countryCodeType;
    public String stateOrProvince;
    public String cityOrLocality;
    public String postalCode;
    public String streetAddress;
    public String streetAddress2;
    public TimeZone timezone;
    public Locale locale;
    public Date lastUpdateTimestamp;

    public ClientLocation(String countryCode, String countryCodeType, String stateOrProvince, String cityOrLocality, String postalCode, String streetAddress, Date lastUpdateTimestamp) {
        this(countryCode, countryCodeType, stateOrProvince, cityOrLocality, postalCode, streetAddress, null, null, null, lastUpdateTimestamp);
        Trace.trace(TRACE_MASKT, "<> ClientLocation.ClientLocation(countryCode=" + countryCode + ", " + "countryCodeType=" + countryCodeType + ", " + "stateOrProvince=" + stateOrProvince + ", " + "cityOrLocality=" + cityOrLocality + ", " + "postalCode=" + postalCode + ", " + "streetAddress=" + streetAddress + ", " + "lastUpdateTimestamp=" + lastUpdateTimestamp + ")");
    }

    public ClientLocation(String countryCode, String countryCodeType, String stateOrProvince, String cityOrLocality, String postalCode, String streetAddress, String streetAddress2, TimeZone timezone, Locale locale, Date lastUpdateTimestamp) {
        this.countryCode = countryCode;
        this.countryCodeType = countryCodeType;
        this.stateOrProvince = stateOrProvince;
        this.cityOrLocality = cityOrLocality;
        this.postalCode = postalCode;
        this.streetAddress = streetAddress;
        this.streetAddress2 = streetAddress2;
        this.timezone = timezone;
        this.locale = locale;
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        Trace.trace(TRACE_MASKT, "<> ClientLocation.ClientLocation(countryCode=" + countryCode + ", " + "countryCodeType=" + countryCodeType + ", " + "stateOrProvince=" + stateOrProvince + ", " + "cityOrLocality=" + cityOrLocality + ", " + "postalCode=" + postalCode + ", " + "streetAddress=" + streetAddress + ", " + "streetAddress2=" + streetAddress2 + ", " + "timezone=" + timezone + ", " + "locale=" + locale + ", " + "lastUpdateTimestamp=" + lastUpdateTimestamp + ")");
    }

    public String toXml() {
        Trace.trace(TRACE_MASKT, "-> ClientLocation.toXml()");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(CLIENT_LOCATION);
        buffer.append(" ");
        buffer.append("country-code=\"" + SasUtil.convert4Xml(this.countryCode) + "\"");
        buffer.append(" ");
        buffer.append("country-code-type=\"" + SasUtil.convert4Xml(this.countryCodeType) + "\"");
        buffer.append(" ");
        buffer.append("state-or-province=\"" + SasUtil.convert4Xml(this.stateOrProvince) + "\"");
        buffer.append(" ");
        buffer.append("city-or-locality=\"" + SasUtil.convert4Xml(this.cityOrLocality) + "\"");
        buffer.append(" ");
        buffer.append("postal-code=\"" + SasUtil.convert4Xml(this.postalCode) + "\"");
        buffer.append(" ");
        buffer.append("street-address=\"" + SasUtil.convert4Xml(this.streetAddress) + "\"");
        if (this.streetAddress2 != null && this.streetAddress2.length() > 0) {
            buffer.append(" ");
            buffer.append("street-address2=\"" + SasUtil.convert4Xml(this.streetAddress2) + "\"");
        }
        if (this.timezone != null) {
            buffer.append(" ");
            buffer.append("timezone=\"" + SasUtil.convert4Xml(this.timezone.getID()) + "\"");
        }
        if (this.locale != null) {
            buffer.append(" ");
            buffer.append("locale=\"" + SasUtil.convert4Xml(this.locale.toString()) + "\"");
        } else {
            buffer.append(" ");
            buffer.append("locale=\"" + SasUtil.convert4Xml(Locale.getDefault().toString()) + "\"");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        buffer.append(" ");
        buffer.append("last-update_TIMESTAMP=\"" + SasUtil.convert4Xml(simpleDateFormat.format(this.lastUpdateTimestamp)) + "\"");
        buffer.append("/>");
        Trace.trace(TRACE_MASKT, "<- ClientLocation.toXml()");
        return buffer.toString();
    }

    public Object clone() {
        Trace.trace(TRACE_MASKT, "-> ClientLocation.clone()");
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- ClientLocation.clone()");
        return object;
    }

    public boolean equals(Object object) {
        Trace.trace(TRACE_MASKT, "-> ClientLocation.equals(" + object + ")");
        boolean result = false;
        if (object != null && object instanceof ClientLocation) {
            ClientLocation clientLocation = (ClientLocation)object;
            if (this.countryCode.equals(clientLocation.countryCode) && this.countryCodeType.equals(clientLocation.countryCodeType) && this.stateOrProvince.equals(clientLocation.stateOrProvince) && this.cityOrLocality.equals(clientLocation.cityOrLocality) && this.postalCode.equals(clientLocation.postalCode) && this.streetAddress.equals(clientLocation.streetAddress) && this.streetAddress2.equals(clientLocation.streetAddress2) && this.timezone.equals(clientLocation.timezone) && this.locale.equals(clientLocation.locale) && this.lastUpdateTimestamp.equals(clientLocation.lastUpdateTimestamp)) {
                result = true;
            }
        }
        Trace.trace(TRACE_MASKT, "<- ClientLocation.equals()");
        return result;
    }
}

